module My_RPG


  class My_Page < RPG::Event::Page

    include My_DB_Text
    include Module_Page

    # DMK
    attr_accessor :liste
    attr_accessor :numero
    attr_accessor :event
    attr_accessor :indents

    def initialize(numero)

      @move_type = 0
      @move_speed = 3
      @move_frequency = 3

      @walk_anime = true
      @step_anime = false
      @direction_fix = false
      @through = false
      @always_on_top = false
      @trigger = 0

      @liste = {}
      @numero = numero
      @condition = nil # change
      @graphic =  nil # change
      @list = [] # change
      @move_route = My_RPG::My_MoveRoute.new

      # Pour stocker les indentations de chaque instruction
      @indents = {}

    end


    def instructions
      return @list
    end


    def to_rm03

      cont = ""

      for element in @liste.sort
        cont << to_128(element[0]) << str_sized(element[1])
      end

      contenu = ""

      for instruction in self.instructions
        contenu << compacter_instruction(instruction)
      end

      # On ajoute la fin de page
      #contenu << "\000"*4

      page_size = to_128(contenu.size)

      # On place la premire taille de la page (lment 51), plus la page elle-mme
      cont << to_128_inf(51) << str_sized(page_size) << to_128_inf(52) << str_sized(contenu) << "\000"

      return cont

    end




    @@count_inst = 0
    def compacter_instruction(instruction)

      @@count_inst += 1

      if instruction.is_a?(Array)

        code = instruction[0]

        if $code_ansi.include?(code)
          new_instr = to_128(code) + to_128(instruction[1]) + sized_string_ansi(instruction[2][0]) + sized_string(instruction[2][1])
        else
          new_instr = to_128(code) + to_128(instruction[1]) + sized_string(instruction[2][0]) + sized_string(instruction[2][1])
        end

        return new_instr
      end

      # My_EventCommand
      #p instruction
      new_instr = instruction.to_rm03
      #p new_instr
      return new_instr

    end





    def to_rmxp
      
      page = RPG::Event::Page.new

      page.condition = @condition
      page.graphic = @graphic
      page.move_type = @move_type
      page.move_speed = @move_speed
      page.move_frequency = @move_frequency
      page.move_route = @move_route.to_rmxp
      page.walk_anime = @walk_anime
      page.step_anime = @step_anime
      page.direction_fix = @direction_fix
      page.through = @through
      page.always_on_top = @always_on_top
      page.trigger = @trigger

  
      #list = separer_instructions(self.instructions.clone)
      # On retire l'instruction vide
      page.list = []

      list = self.instructions

      i = 0
      while i < list.size
        #pa i, list[i].code
        #getz

        rmxp = list[i].to_rmxp
   

        if rmxp.is_a?(Array) == false
          page.list << rmxp
        else
          # AMELIORER CONCAT
          page.list = page.list.concat(rmxp)
          #p list[i].move_route.list.size
        end

        #p page.list
        #getz
        
        i += 1
        break if i == list.size
      end

      


      return page
    end


    def map
      return @event.map
    end


    
    # Clone une page et ses sous-lments composs d'objets
    def clone
      page = My_Page.new(@numero)

      page.condition = @condition.clone if @condition != nil # objet
      page.graphic = @graphic.clone if @graphic != nil # objet
      page.move_type = @move_type
      page.move_speed = @move_speed
      page.move_frequency = @move_frequency
      page.move_route = @move_route.clone if @move_route != nil # objet
      page.walk_anime = @walk_anime
      page.step_anime = @step_anime
      page.direction_fix = @direction_fix
      page.through = @through
      page.always_on_top = @always_on_top
      page.trigger = @trigger
  
      for i in 0...@list.size
        page.instructions[i] = @list[i].clone
      end
  
      return page
    end






    def recuperer_code_objet(codes)


      page_instr = recuperer_cod(codes, self.instructions)

      # Rcupration des instructions de Move Route
      for i in 0...self.move_route.list.size
        instruction = self.move_route.list[i]

        # On regarde si le code de l'instruction fait partie des codes recherchs
        next if codes.include?(instruction.code) == false

        if page_instr == nil
          page_instr = Page_Instruction.new(self)
        end
        page_instr.add_instruction_route(instruction, i)

      end
      

      return page_instr
    end

    



    def total_instruction
      return self.instructions.size
    end



    def recuperer_ressource
      ressources = []
      if self.graphic.character_name != ""
        res = My_Ressource.new(self.graphic.character_name, D_CHARACTERS)
        ressources << Instruction_Page.new(nil, nil, self, res)
      end
      return ressources
    end


    def recuperer_message(pos)
      message = self.instructions[pos]
      suite = []
      i = pos+1
      while self.instructions[i].is_a?(My_RPG::My_Command_Message_Suite)
        suite << self.instructions[i]
        i += 1
      end
      return [message, *suite]
    end





    def position
      return "#{self.map.numero}:#{self.event.numero}:#{self.numero}"
    end

    def get_position_str(pos)
      return sprintf("[Map:%d:%d:%d:%d]", map.numero, event.numero, @numero, pos)
    end



=begin

=end


  end
end